<?php
/*--------------------------------------------------------------------
 ReadService.php 2020-2-20
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Attributes\SellingUnitModel\Database\Service;

use Gambio\Shop\Attributes\SellingUnitModel\Database\Repository\DTO\AttributesModelDto;
use Gambio\Shop\Attributes\SellingUnitModel\Database\Repository\DTO\OptionValuesIdDto;
use Gambio\Shop\Attributes\SellingUnitModel\Database\Repository\RepositoryInterface;

/**
 * Class ReadService
 * @package Gambio\Shop\Attributes\SellingUnitModel\Database\Service
 */
class ReadService implements ReadServiceInterface
{
    /**
     * @var RepositoryInterface
     */
    protected $repository;
    
    
    /**
     * ReadService constructor.
     *
     * @param RepositoryInterface $repository
     */
    public function __construct(RepositoryInterface $repository)
    {
        $this->repository = $repository;
    }
    
    
    /**
     * @inheritDoc
     */
    public function attributeModelByOptionValuesId(OptionValuesIdDto $dto): AttributesModelDto
    {
        return $this->repository->attributeModelByOptionValuesId($dto);
    }
}